import electric.uddi.Category;
import electric.uddi.Description;
import electric.uddi.IUDDI;
import electric.uddi.IUDDIConstants;
import electric.uddi.Overview;
import electric.uddi.TModel;
import electric.uddi.UDDIException;
import electric.uddi.client.UDDIClient;

public class TemplateModel {

	public static void main(String[] args) throws Exception {

		String tModelName = "sw-hotellerie-xml-org:reservation";

		String inquireURL = "";
		String publishURL = "";
		String user = "";
		String password = "";

		// Rcupration des paramtres du registre UDDI.
		if(args.length > 0) {
			inquireURL = args[0];
			publishURL = args[1];
			user = args[2];
			password = args[3];
		}
		
		if (inquireURL.equals("")) {
			inquireURL = "http://www.sw-registre-uddi.org:8004/glue/inquire/uddi";
		}
		if (publishURL.equals("")) {
			publishURL = "http://www.sw-registre-uddi.org:8006/glue/publish/uddi";
		}
		if (user.equals("")) {
			user = "uddi";
		}
		if (password.equals("")) {
			password = "uddi";
		}

		// Instanciation du client UDDI.
		IUDDI uddi = new UDDIClient(inquireURL, publishURL, user, password);

		// Instanciation du service type de rservation.
		TModel tModel = new TModel(tModelName);

		// Catgorisation du service type en tant que spcification WSDL.
		Category category = new Category("uddi-org:types", "wsdlSpec");
		category.setTModelKey(IUDDIConstants.UDDI_TYPE_TAXONOMY_NAME_UUID);
		tModel.addCategory(category);

		// Catgorisation du service type en "On-Line Information Services" (NAICS).
		category = new Category("On-Line Information Services", "514191");
		category.setTModelKey(IUDDIConstants.UDDI_NAICS_UUID);
		tModel.addCategory(category);

		// Catgorisation du service type en "Internet and intranet software" (UNSPSC).
		category = new Category("Internet and intranet software", "431628");
		category.setTModelKey(IUDDIConstants.UDDI_UNSPSC_UUID);
		tModel.addCategory(category);

		// Ajout des descriptions du service type.
		Description description = new Description("Travel reservation service", "en");
		tModel.addDescription(description);
		description = new Description("Service de rservation de voyages", "fr");
		tModel.addDescription(description);

		// Affecte l'URL de rsum du service type.
		String url = "http://www.sw-hotellerie-xml.org:8080/reservation_sw-hotellerie-xml/services-type/ReservationService-interface.wsdl";
		description = new Description("Fichier de description WSDL du service de rservation de voyages.", "fr");
		Overview overview = new Overview(description, url);
		tModel.setOverview(overview);

		// Publication du service type.
		try {
			TModel savedTModel = uddi.saveTModel(tModel);
			System.out.println("\nservice type publi\n" + savedTModel);
		}
		catch (UDDIException e) {
			System.out.println("\nune exception " + e + " s'est produite : " + e.getDispositionReport());
		}
	}
}